#ifndef CGEN2SETEPCDIALOG_H
#define CGEN2SETEPCDIALOG_H

#include <QDialog>
#include <ui_CGen2SetEPCDialog.h>
#include "../../../ui/ConfigDialog.h"

#include <QrfeReaderInterfaceGlobal>

class QrfeGen2Tag;

class CGen2SetEPCDialog : public QDialog, ConfigDialog
{
    Q_OBJECT

public:
    CGen2SetEPCDialog(QWidget *parent = 0);
    ~CGen2SetEPCDialog();

    QString newEPC();

public slots:
    int exec(QrfeGen2Tag* tag);

    void tryAccept();

private slots:
    void newEpcSizeChanged(int newEpcSize);
    void textChanged();

private:
    QByteArray getNewEPC();
    void setNewEPC(const QByteArray& epc);

private:
	QrfeGen2Tag* 		m_tag;
    int                 m_newEpcSize;
	QByteArray 			m_oldEPC;
	QString				m_newEPC;
	QList<QLineEdit*>	m_newEpcEdits;

    bool                m_textChangeActive;

    Ui::CGen2SetEPCDialogClass ui;
};

#endif // CGEN2SETEPCDIALOG_H
